# Kündigung

Ein abgeschlossener Vertrag kann zur Kündigung in den Umlauf gegeben werden. Der Vertrag durchläuft hier einen Freigabeprozess, welcher mit dessen <span
style='font-weight:bold;font-style:italic'>Freigabe</span> oder <span
style='font-weight:bold;font-style:italic'>Ablehnung</span> endet. Somit können unterschiedliche Personen im Unternehmen am Kündigungsverfahren beteiligt werden. 


{@img img1.png}

Während des Kündigungsprozesses behält der Vertrag seinen bestehenden Status, so dass Auswertungen (Aktiv/ Inaktiv) davon nicht betroffen sind. Gekündigte Verträge werden mithilfe des Status &quot;Gekündigt&quot; gekennzeichnet.

> <span
style='font-style:italic'>Ein Vertragsmanager erhält eine Erinnerung zu einem Vertrag, welcher in 2 Wochen gekündigt werden muss. Er startet ein Kündigungsverfahren, in dem alle vom Vertrag betroffenen Mitarbeiter beteiligt werden. Nachdem die Kündigung freigegeben wurde, kündigt er den Vertrag.</span>

{@img img3.png}

## Prüfungsschritte

Schritte innerhalb der Vertragskündigung werden als Prüfungsschritte bezeichnet. Im Kern sind Prüfungsschritte definiert durch alle Benutzer und Gruppen, die im Prozess beteiligt sind. Die Liste der Prüfungsschritte kann zur Laufzeit bearbeitet werden. Dies erlaubt es, weitere Schritte einzufügen oder Schritte zu entfernen, wenn diese bspw. nicht mehr notwendig sind.

Dürfen Schritte von den Folgebenutzern nicht bearbeitet werden, kann dies über die Option &quot;verpflichtend&quot; gesteuert werden.

{@img img5.png}

Im Prozess wird die Liste über einen Zyklus von oben abgearbeitet. Wird der Workflow einem Anwender zur Prüfung der Kündigung zugestellt, wird dieser (erster Benutzer der Liste) aus der Liste entfernt. Dies führt zur nachfolgenden Abarbeitung der Prozessschritte.

Die Prüfschritte der Kündigung können über die Rollen-Konfiguration gesteuert werden. Diese findet sich in der Konfiguration des Vertragsmanagements in der Einstellung <span
style='font-weight:bold;font-style:italic'>Dynamische Benutzerrollen</span>. Die Rolle für die Kündigung ist <span
style='font-weight:bold;font-style:italic'>TERMINATION</span>.

{@img img7.png}

## Berechtigungserweiterung im Kündigungsprozess

Teilnehmenden Benutzern werden je nach Konfiguration im Workflow Rechte eingeräumt, so dass diese Verträge sehen dürfen. Weitere Informationen zur Berechtigungserweiterung gibt das Kapitel <a
href="#!/guide/p89F88CAF_C876_4A5C_8F86_B7348320FF1C">Berechtigungen</a>.

## Aktion: Kündigung einleiten

Die Aktion kann im Reiter `Verträge` der Multifunktionsleiste aufgerufen werden. 

{@img img9.png}

### Vorbedingungen

*   Ein Vertrag ist ausgewählt.

### Dateneingabe

Für die Dateneingabe wird die Formular-Tab-Gruppe `006_1_initiate_termination` eingesetzt. 

{@img img11.png}

Diese setzt sich aus folgenden Bausteinen zusammen:

<table><thead><tr><td><span
style='font-weight:bold'>Kündigung</span></td></tr></thead><tbody><tr><td>630_initiate_termination</td></tr><tr><td>100_users</td></tr></tbody></table>


### Dateneingabe: Prüfung der Vertragsdaten

Für die Dateneingabe wird die Formular-Tab-Gruppe `006_2_approve_termination` eingesetzt. 

{@img img13.png}

Diese setzt sich aus folgenden Bausteinen zusammen:

<table><thead><tr><td><span
style='font-weight:bold'>Kündigung</span></td><td><span
style='font-weight:bold'>Vertragsdaten</span></td><td><span
style='font-weight:bold'>Laufzeit</span></td><td><span
style='font-weight:bold'>Vertragspartner</span></td><td><span
style='font-weight:bold'>Zahlungsplan</span></td></tr></thead><tbody><tr><td>631_approve_termination</td><td>210_general</td><td>310_duration</td><td>510_partner</td><td>410_payment</td></tr><tr><td>100_users</td><td>220_company</td><td></td><td>520_partner_address</td><td></td></tr><tr><td></td><td>230_contract_data</td><td></td><td></td><td></td></tr><tr><td></td><td>240_accounting</td><td></td><td></td><td></td></tr><tr><td></td><td>250_project</td><td></td><td></td><td></td></tr></tbody></table>


### Dateneingabe: Abschluss des Freigabeprozesses

Für die Dateneingabe wird die Formular-Tab-Gruppe `006_3_finish_termination` eingesetzt. 

{@img img15.png}

Diese setzt sich aus folgenden Bausteinen zusammen:

<table><thead><tr><td><span
style='font-weight:bold'>Kündigung</span></td><td><span
style='font-weight:bold'>Vertragsdaten</span></td><td><span
style='font-weight:bold'>Laufzeit</span></td><td><span
style='font-weight:bold'>Vertragspartner</span></td><td><span
style='font-weight:bold'>Zahlungsplan</span></td></tr></thead><tbody><tr><td>632_finish_termination</td><td>210_general</td><td>310_duration</td><td>510_partner</td><td>410_payment</td></tr><tr><td></td><td>220_company</td><td></td><td>520_partner_address</td><td></td></tr><tr><td></td><td>230_contract_data</td><td></td><td></td><td></td></tr><tr><td></td><td>240_accounting</td><td></td><td></td><td></td></tr><tr><td></td><td>250_project</td><td></td><td></td><td></td></tr></tbody></table>

### Implementierung

<span class="tag_warning"><span
style='font-weight:bold'>Action definitions:</span> Definitionen der Aktion für die Clients finden sich in der Konfiguration `sol.contract.InitiateTermination`.</span>

Der <span
style='font-weight:bold'>technische Ablauf</span> wird durch die Index Server Aktion `sol.contract.ix.actions.TerminateContract` implementiert. Diese startet den Workflow `sol.contract.contract.termination`.

Im Erfolgsfall werden folgende Events an den Client übermittelt:

<table><thead><tr><td>Event</td><td>Beschreibung</td><td>Status</td></tr></thead><tbody><tr><td>DIALOG</td><td>Zeigt das Formular zur Dateneingabe in einem Dialog an.</td><td></td></tr><tr><td>REFRESH</td><td>Aktualisiert die Darstellung des SORD-Objekts.</td><td></td></tr></tbody></table>

<span
style='font-weight:bold'>Beschreibung des Workflows</span>

{@img img17.png}

<table><thead><tr><td><span
style='font-weight:bold'>Knotenbezeichnung</span></td><td><span
style='font-weight:bold'>Knotenname deutsch und Beschreibung</span></td><td><span
style='font-weight:bold'>Funktion</span></td></tr></thead><tbody><tr><td><span
style='font-weight:bold'>USERROLESTOMAP</span></td><td><span
style='font-weight:bold'>USERROLESTOMAP</span><br />Verteilungsknoten: Speichert die für den Kündigungsprozess vorgegebenen Benutzerrollen in eine Map Table</td><td>sol.common.ix.functions.UserRolesToMap</td></tr><tr><td><span
style='font-weight:bold'>Set approver</span></td><td><span
style='font-weight:bold'>Prüfer festlegen</span><br />Benutzerknoten: Auswahl eines oder mehrerer Prüfer für die Kündigung</td><td></td></tr><tr><td><span
style='font-weight:bold'>Dynamic flow has approval steps?</span></td><td><span
style='font-weight:bold'>Check ad-hoc flow start</span><br />Entscheidungsknoten: Prüft das Feld ELO_WF_STATUS auf den Wert `CYCLE_START`, um in diesem Fall einen Freigabe-Zyklus zu starten</td><td>sol.common.ix.functions.CheckDynAdHocFlowStart</td></tr><tr><td><span
style='font-weight:bold'>STATUS: Terminated</span></td><td><span
style='font-weight:bold'>STATUS: Gekündigt</span><br />Verteilungsknoten: Setzt das Indexfeld CONTRACT_STATUS auf `T`</td><td>sol.common.ix.functions.Status</td></tr><tr><td><span
style='font-weight:bold'>CHANGECOLOR: Terminated</span></td><td><span
style='font-weight:bold'>CHANGECOLOR: Gekündigt</span><br />Verteilungsknoten: Setzt die Farbe des SORD Objekts</td><td>sol.common.ix.functions.ChangeColor</td></tr><tr><td><span
style='font-weight:bold'>FEED: Immediate termination</span></td><td><span
style='font-weight:bold'>FEED: Sofortige Kündigung</span><br />Verteilungsknoten: Legt einen Feed-Eintrag zur Kündigung ohne weitere Prüfungen an</td><td>sol.common.ix.functions.FeedComment</td></tr><tr><td><span
style='font-weight:bold'>FEED: Termination initiated</span></td><td><span
style='font-weight:bold'>FEED: Kündigung eingeleitet</span><br />Verteilungsknoten: Legt einen Feed-Eintrag zur Einleitung der Kündigung an</td><td>sol.common.ix.functions.FeedComment</td></tr><tr><td><span
style='font-weight:bold'>CHANGEUSER: Termination</span></td><td><span
style='font-weight:bold'>CHANGEUSER: Kündigung</span><br />Verteilungsknoten: Ändert den Eigentümer des nächsten Benutzerknotens</td><td>sol.common.ix.functions.ChangeUser</td></tr><tr><td><span
style='font-weight:bold'>Approval</span></td><td><span
style='font-weight:bold'>Genehmigung</span><br />Benutzerknoten: Genehmigung durch einen vorgegebenen Prüfer</td><td></td></tr><tr><td><span
style='font-weight:bold'>FEED: Termination accepted</span></td><td><span
style='font-weight:bold'>FEED: Kündigung anerkannt</span><br />Verteilungsknoten: Legt einen Feed-Eintrag zur Anerkennung der Kündigung an</td><td>sol.common.ix.functions.FeedComment</td></tr><tr><td><span
style='font-weight:bold'>FEED: Termination rejected</span></td><td><span
style='font-weight:bold'>FEED: Kündigung abgelehnt</span><br />Verteilungsknoten: Legt einen Feed-Eintrag zur Ablehnung der Kündigung an</td><td>sol.common.ix.functions.FeedComment</td></tr><tr><td><span
style='font-weight:bold'>Check rejected</span></td><td><span
style='font-weight:bold'>Check rejected</span><br />Entscheidungsknoten: Prüft das Feld ELO_WF_STATUS auf den Wert `REJECTED`, um den Kündigungsprozess entsprechend abzuschließen</td><td></td></tr><tr><td><span
style='font-weight:bold'>Termination approved</span></td><td><span
style='font-weight:bold'>Kündigung genehmigt</span><br />Benutzerknoten: Zur Kenntnisnahme der Anerkennung</td><td></td></tr><tr><td><span
style='font-weight:bold'>FEED: Termination completed</span></td><td><span
style='font-weight:bold'>FEED: Kündigungsprozess abgeschlossen</span><br />Verteilungsknoten: Legt einen Feed-Eintrag zum Abschluss des Kündigungsprozesses an</td><td>sol.common.ix.functions.FeedComment</td></tr><tr><td><span
style='font-weight:bold'>Termination rejected</span></td><td><span
style='font-weight:bold'>Kündigung abgelehnt</span><br />Benutzerknoten: Zur Kenntnisnahme der Ablehnung</td><td></td></tr><tr><td><span
style='font-weight:bold'>FEED: Termination declined</span></td><td><span
style='font-weight:bold'>FEED: Kündigung abgewiesen</span><br />Verteilungsknoten: Legt einen Feed-Eintrag zur Abweisung der Kündigung an</td><td>sol.common.ix.functions.FeedComment</td></tr><tr><td><span
style='font-weight:bold'>SET: Delete comment</span></td><td><span
style='font-weight:bold'>SET</span><br />Entfernt das Kommentar des Vorgängers aus der WF_MAP</td><td>sol.common.ix.function.Set</td></tr></tbody></table>


